 // ----------------------------------------------------------------------------------
 // Uio.h	-- file i/o class
 // Uio.cp
 // ----------------------------------------------------------------------------------
 
 
 #ifndef _UIO_
 #define _UIO_

#include "platform.h"
#ifdef _MACINTOSH_
#include <Aliases.h>
#include <Script.h>
//#include <StandardFile.h>
#include <Files.h>
#include <Types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "TSpell.h"

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


 class Uio {
 public:
 	Uio();
 	Uio(FioParam *fileSpec);
 	
#ifdef _MACINTOSH_ 	
 	Uio(AliasHandle theAlias, Boolean wasChanged, FSSpec *fileSpec);
#endif

 	~Uio();
 	
 	void GetSpecifier(FioParam *fileSpec);
 	void SetSpecifier(FioParam *fileSpec);
#ifdef _MACINTOSH_ 	
 	AliasHandle MakeAlias(FioParam *fileSpec);

 
 	short GetRefNum();
	 	 	
 	short GetFile(short numTypes, SFTypeList types);
 	short PutFile(ConstStr255Param prompt, ConstStr255Param defaultName);
 #else
 	FILE *GetRefNum();
 #endif
 
 #ifdef _MACINTOSH_ 
 	void Create(OSType inCreator = 'SPEL', OSType inFileType = 'TEXT', 
 			ScriptCode inScriptCode = nil);
 	short Open(char Permission = fsCurPerm);

#else
	void Create();
	short Open();
#endif

 	void	Close();
 	long	Exist();
 	void SetPos(long offset, short where);
 	long GetPos();
 	void SetLength(long theLength);
 	long GetLength();
 	
 	void *ReadFile();
 	long	WriteFile(const void *buf, long count);
 	
 	long WriteData(const void *buf, long count);
 	long ReadData(void *buf, size_t count);
 	
 	char *getstring(char *theString, long size);
 	short putstring(char *theString);
 	char *GetWord();
 	void PutWord(char *Word);
 	
 	short eof();
 	
 protected:
 #ifdef _MACINTOSH_ 	

 	FSSpec	mMacFile;
 	short	mRefNum;
#else
	FILE		*theFile;
	char		theName[80];
#endif
 };
 
 #endif
